/*
 * Decompiled with CFR 0.152.
 */
package org.minimallycorrect.libloader;

import java.beans.ConstructorProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraftforge.fml.relauncher.IFMLLoadingPlugin;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.minimallycorrect.libloader.LibLoaderChained;
import sun.misc.URLClassPath;

@IFMLLoadingPlugin.Name(value="LibLoader")
public class LibLoader
implements IFMLLoadingPlugin {
    private static final Logger log = LogManager.getLogger((String)"LibLoader");
    private static final AtomicBoolean inited = new AtomicBoolean();

    public LibLoader() {
        LibLoader.init();
    }

    public static void init() {
        boolean anyChanges;
        if (!inited.compareAndSet(false, true)) {
            return;
        }
        File mods = new File(System.getProperty("LibLoader.modsFolder", "mods/"));
        File libraries = new File(System.getProperty("LibLoader.librariesFolder", "libraries/"));
        File state = new File(libraries, "libloader mod state.obj");
        File libLoaderJar = new File(mods, System.getProperty("LibLoader.coreModJar", "# LibLoader.jar"));
        File tempDeleteMe = new File(libLoaderJar.getParentFile(), libLoaderJar.getName() + "-delete-me.tmp");
        LibLoader.delete(tempDeleteMe);
        List lastStates = (List)LibLoader.readFromFile(state);
        ArrayList<FileState> newStates = new ArrayList<FileState>();
        LibLoader.search(newStates, mods, 0);
        LibLoader.saveToFile(newStates, state);
        boolean bl = anyChanges = !libLoaderJar.exists() || !Objects.equals(newStates, lastStates);
        if (anyChanges && LibLoader.checkForNewerLibLoader(mods, libLoaderJar, tempDeleteMe)) {
            LibLoader.delete(state);
            LibLoader.delete(libLoaderJar);
            LibLoader.delete(tempDeleteMe);
            return;
        }
        LibLoader.launch(anyChanges);
        LibLoader.saveToFile(newStates, state);
    }

    private static void delete(File f) {
        if (f.isFile() && !f.delete()) {
            f.deleteOnExit();
        }
    }

    private static void launch(boolean anyChanges) {
        System.setProperty("LibLoader.anyChanges", String.valueOf(anyChanges));
        LibLoaderChained.init();
    }

    private static boolean checkForNewerLibLoader(File mods, File libLoaderJar, File tempDeleteMe) {
        boolean delete;
        File[] files = mods.listFiles();
        if (files == null) {
            throw new FileNotFoundException(mods.getAbsolutePath());
        }
        Version currentVersion = null;
        Version bestVersion = null;
        File bestFile = null;
        for (File file : files) {
            Version version2;
            Throwable throwable;
            FileSystem fs;
            block42: {
                block43: {
                    block40: {
                        block41: {
                            String name = file.getName().toLowerCase();
                            if (!name.endsWith(".jar") && !name.endsWith(".zip")) continue;
                            fs = FileSystems.newFileSystem(file.toPath(), null);
                            throwable = null;
                            version2 = new Version(new String(Files.readAllBytes(fs.getPath("LibLoader.version", new String[0])), Charset.forName("UTF-8")));
                            if (!name.equalsIgnoreCase(libLoaderJar.getName())) break block40;
                            currentVersion = version2;
                            if (fs == null) continue;
                            if (throwable == null) break block41;
                            try {
                                fs.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            continue;
                        }
                        fs.close();
                        continue;
                    }
                    Path libLoader = fs.getPath("LibLoader.jar", new String[0]);
                    if (Files.exists(libLoader, new LinkOption[0])) break block42;
                    log.warn("Found LibLoader version '" + version2 + "' in '" + file + "' but no LibLoader.jar");
                    if (fs == null) continue;
                    if (throwable == null) break block43;
                    try {
                        fs.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                fs.close();
                continue;
            }
            try {
                try {
                    if (bestVersion != null && version2.compareTo(bestVersion) <= 0) continue;
                    bestVersion = version2;
                    bestFile = file;
                }
                catch (IOException version2) {
                }
                catch (Throwable t) {
                    log.error("Failed to check LibLoader version in '" + file + '\'', t);
                }
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            catch (Throwable throwable5) {
                throw throwable5;
            }
            finally {
                if (fs != null) {
                    if (throwable != null) {
                        try {
                            fs.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                    } else {
                        fs.close();
                    }
                }
            }
        }
        boolean update = bestVersion != null && (currentVersion == null || bestVersion.compareTo(currentVersion) > 0);
        boolean bl = delete = libLoaderJar.exists() && (update || bestVersion == null);
        if (delete || update) {
            log.info("LibLoader change: \ncurrentVersion " + currentVersion + "\nbestVersion " + bestVersion + "\nbestFile " + bestFile + "\ndelete " + delete + "\nupdate " + update);
        }
        if (delete) {
            LibLoader.changeClassLoaderUrls(libLoaderJar, true);
            Files.move(libLoaderJar.toPath(), tempDeleteMe.toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
            LibLoader.delete(tempDeleteMe);
        }
        if (update) {
            try (FileSystem fs = FileSystems.newFileSystem(bestFile.toPath(), null);){
                Path libLoader = fs.getPath("LibLoader.jar", new String[0]);
                Files.copy(libLoader, libLoaderJar.toPath(), new CopyOption[0]);
            }
            LibLoader.changeClassLoaderUrls(libLoaderJar, false);
        }
        return delete && bestVersion == null;
    }

    private static void changeClassLoaderUrls(File libLoaderJar, boolean remove) {
        URLClassLoader classLoader = (URLClassLoader)LibLoader.class.getClassLoader();
        Field ucpField = URLClassLoader.class.getDeclaredField("ucp");
        ucpField.setAccessible(true);
        URLClassPath oldUcp = (URLClassPath)ucpField.get(classLoader);
        ArrayList<URL> urls = new ArrayList<URL>();
        URL libLoaderUrl = libLoaderJar.toURI().toURL();
        for (URL url : classLoader.getURLs()) {
            if (urls.contains(url)) continue;
            urls.add(url);
        }
        if (!urls.remove(libLoaderUrl) && remove) {
            log.error("Failed to remove " + libLoaderUrl + " from urls: " + urls);
        }
        if (!remove) {
            urls.add(Math.min(1, urls.size()), libLoaderUrl);
        }
        ucpField.set(classLoader, new URLClassPath(urls.toArray(new URL[0])));
        oldUcp.closeLoaders();
    }

    private static <T> void saveToFile(T toSave, File f) {
        try {
            f.getParentFile().mkdirs();
            File temp = new File(f.getParentFile(), f.getName() + ".temp");
            try (ObjectOutputStream os = new ObjectOutputStream(new FileOutputStream(temp));){
                os.writeObject(toSave);
            }
            Files.move(temp.toPath(), f.toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
        }
        catch (IOException temp) {
        }
        catch (Throwable t) {
            log.error("Failed to save '" + f + '\'', t);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static <T> T readFromFile(File f) {
        try (ObjectInputStream is2222 = new ObjectInputStream(new FileInputStream(f));){
            Object object = is2222.readObject();
            return (T)object;
        }
        catch (IOException is2222) {
            return null;
        }
        catch (Throwable t) {
            log.error("Failed to read '" + f + '\'', t);
        }
        return null;
    }

    private static void search(List<FileState> fileStates, File directory, int depth) {
        if (depth > 20) {
            throw new IllegalArgumentException(directory + " depth too high: " + depth);
        }
        File[] files = directory.listFiles();
        if (files == null) {
            throw new IOException(directory + " is not a directory");
        }
        for (File f : files) {
            String name = f.getName();
            String lName = name.toLowerCase();
            if (f.isDirectory()) {
                if (depth == 0 && !"mods".equals(lName) && !"libraries".equals(lName)) continue;
                LibLoader.search(fileStates, f, depth + 1);
                continue;
            }
            if (!lName.endsWith(".jar") && !lName.endsWith(".jlib") && !lName.endsWith(".zip")) continue;
            fileStates.add(new FileState(f));
        }
        fileStates.sort(Comparator.comparing(a -> ((FileState)a).path));
    }

    public String[] getASMTransformerClass() {
        return new String[0];
    }

    public String getModContainerClass() {
        return null;
    }

    public String getSetupClass() {
        return null;
    }

    public void injectData(Map<String, Object> var1) {
    }

    public String getAccessTransformerClass() {
        return null;
    }

    static class Version
    implements Comparable<Version> {
        final int[] parts;
        final String suffix;

        Version(String version) {
            if (version == null) {
                throw new IllegalArgumentException("Version can not be null");
            }
            int dash = (version = version.trim()).indexOf(45);
            if (dash != -1) {
                this.suffix = version.substring(dash + 1).trim();
                version = version.substring(0, dash);
            } else {
                this.suffix = null;
            }
            if (!version.matches("[0-9]+(\\.[0-9]+)*")) {
                throw new IllegalArgumentException("Invalid version format. Should consist of digits and dots with optional suffix after -. Got '" + version + "'");
            }
            this.parts = Arrays.stream(version.split("\\.")).mapToInt(Integer::parseInt).toArray();
        }

        @Override
        public int compareTo(Version that) {
            if (that == null) {
                return 1;
            }
            if (this == that) {
                return 0;
            }
            int length = Math.max(this.parts.length, that.parts.length);
            for (int i = 0; i < length; ++i) {
                int thatPart;
                int thisPart = i < this.parts.length ? this.parts[i] : 0;
                int n = thatPart = i < that.parts.length ? that.parts[i] : 0;
                if (thisPart < thatPart) {
                    return -1;
                }
                if (thisPart <= thatPart) continue;
                return 1;
            }
            String a = this.suffix;
            String b = that.suffix;
            if (Objects.equals(a, b)) {
                return 0;
            }
            int s = Integer.compare(this.suffixInt(), that.suffixInt());
            if (s != 0) {
                return s;
            }
            if (a == null) {
                return -1;
            }
            return a.compareTo(b);
        }

        int suffixInt() {
            if (this.suffix == null) {
                return 0;
            }
            switch (this.suffix.toLowerCase().trim()) {
                case "alpha": {
                    return -3;
                }
                case "beta": 
                case "snapshot": {
                    return -2;
                }
                case "": {
                    return 0;
                }
            }
            return -1;
        }

        public String toString() {
            return String.join((CharSequence)".", Arrays.stream(this.parts).mapToObj(String::valueOf)::iterator) + (this.suffix == null ? "" : '-' + this.suffix);
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public boolean equals(Object that) {
            return this == that || that != null && this.getClass() == that.getClass() && this.compareTo((Version)that) == 0;
        }
    }

    private static class FileState
    implements Serializable {
        private String path;
        private long time;
        private long size;

        FileState(File f) {
            this.path = f.getCanonicalPath();
            this.time = f.lastModified() / 1000L;
            this.size = f.length();
        }

        @ConstructorProperties(value={"path", "time", "size"})
        public FileState(String path, long time, long size) {
            this.path = path;
            this.time = time;
            this.size = size;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FileState)) {
                return false;
            }
            FileState other = (FileState)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$path = this.path;
            String other$path = other.path;
            if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
                return false;
            }
            if (this.time != other.time) {
                return false;
            }
            return this.size == other.size;
        }

        protected boolean canEqual(Object other) {
            return other instanceof FileState;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $path = this.path;
            result = result * 59 + ($path == null ? 43 : $path.hashCode());
            long $time = this.time;
            result = result * 59 + (int)($time >>> 32 ^ $time);
            long $size = this.size;
            result = result * 59 + (int)($size >>> 32 ^ $size);
            return result;
        }
    }
}

